﻿
CREATE FUNCTION [App].[NVCC_udf_ActiveUserCount] ()
RETURNS @ActiveUserCount TABLE
(
	Station varchar(56) NOT NULL,
	ActiveUsers int NOT NULL
)

-- NOTICE:
-- Do not edit the function live on the server. Code to generate
-- the function is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.

AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Brian Diggs
--Object/SP Name        : NVCC_udf_ActiveUserCount
--Server                : 
--Data Base             : CC_REFDOC
--Schema                : App
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 08-02-2016
--
--
--Last Changed          : 2017-07-24
--Last Changed By		: Brian Diggs
--Reason For Change		: Convert from using vNVCC_ProductionAccessLog and
--                        Patient.Patient to using NVCC_ProductionLog.
--                        Also embed sta3n in station name.
--
--Purpose               : To count the number of "active" users.
--==================================================================================
--Uses: App.udf_StationName
--Uses: App.NVCC_ProductionLog

BEGIN
	INSERT @ActiveUserCount
	SELECT
		'[' + convert(varchar(3), sta3n) + '] ' + App.udf_StationName(Sta3n) AS Station,
		COUNT(*) AS ActiveUsers
	FROM (
		SELECT UserID, Sta3n
		FROM
			App.NVCC_ProductionLog
		WHERE AccessDateTime > dateadd(day, -30, convert(date, getutcdate()))
		GROUP BY UserID, Sta3n
		HAVING COUNT(*) >= 10
	) AS U
	GROUP BY U.Sta3n
--	ORDER BY ActiveUsers DESC
	RETURN
END;

